#!/usr/bin/perl

use List::Util qw / min max /;

opendir RGB, "rgb" or die "Couldn't open rgb/\n";

while (my $file = readdir(RGB))
{
	if ($file =~ /^\./) { next; }
	open(IN, "<rgb/$file") or die "Couldn't open $file for reading!\n";
	binmode IN;
	
	# header stuff
	my $read;
	read IN, $read, 16;
	my ($magic, $ver, $leds, $frames, $ticks, $offset) = unpack("LSSSSL", $read);
	
	if ($magic != 0xDEADBEEF || $ver != 1) { next; }
	
	open(OUT, ">hsv/$file") or die "Couldn't open $file for writing!\n";
	binmode OUT;
	
	print "converting: $file, $frames frames\n";
	#print join("\n", ($magic, $ver, $leds, $frames, $ticks, $offset)), "\n";
	
	$ver = 2;
	
	print OUT pack("LSSSSL", ($magic, $ver, $leds, $frames, $ticks, $offset));
	
	seek IN, $offset, SEEK_SET; # move to frames section
	for (my $i = 0; $i < $leds * $frames; $i++)
	{
		read IN, $read, 3;
		my @hsv = rgb_to_hsv(unpack("CCC", $read));
		@hsv = (int($hsv[0] * 255 / 360), int($hsv[1] * 255), int($hsv[2] * 255));
		print OUT pack("CCC", @hsv);
	}
	
	close IN;
	close OUT;
}

closedir RGB;

sub rgb_to_hsv
{
	my ($r, $g, $b) = @_;
	($r, $g, $b) = ($r / 255, $g / 255, $b / 255);
	my $min = min($r, $g, $b);
	my $max = max($r, $g, $b);
    my $h, $s, $v = $max;

    my $d = $max - $min;
    $s = ($max == 0) ? 0 : ($d / $max);

    if($max == $min)
    {
        $h = 0; # achromatic
    }
    else
    {
        if ($max == $r)    { $h = ($g - $b) / $d + ($g < $b ? 6 : 0); }
        elsif ($max == $g) { $h = ($b - $r) / $d + 2; }
        else               { $h = ($r - $g) / $d + 4; }
        $h /= 6;
    }

    return ($h * 360.0, $s * 1.0, $v * 1.0);
}
